<?php

namespace UtillzCore\Templates\Admin\Metabox;

use \UtillzCore\Templates\Admin\Metabox\Field_Column_Sizes;

class Filters {

    static public function get( $id ) {
        return [
            'type' => 'repeater',
            'id' => $id,
            'name' => esc_html__('Filters', 'utillz-core'),
            'templates' => [

                /*
                 * free text
                 *
                 */
                'free_text' => [
                    'name' => esc_html__( 'Static content — free text', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'content' => [
                            'type' => 'textarea',
                            'name' => esc_html__( 'Content', 'utillz-core' ),
                        ],
                        'autop' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Auto-create paragraphs using the line-breaks', 'utillz-core' ),
                            'value' => 1,
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * text
                 *
                 */
                'text' => [
                    'name' => esc_html__( 'Text', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'key',
                            'name' => esc_html__( 'Field key', 'utillz-core' ),
                            'description' => esc_html__( 'The filder id should match the field id you created in Listing Type > Listing > Fields', 'utillz-core' ),
                            'col' => 6
                        ],
                        'placeholder' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * autosuggest
                 *
                 */
                'autosuggest' => [
                    'name' => esc_html__( 'Text — auto suggest', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'key',
                            'name' => esc_html__( 'Key', 'utillz-core' ),
                            'defined' => false,
                            'col' => 6
                        ],
                        'placeholder' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                            'col' => 6
                        ],
                        'criteria' => [
                            'type' => 'repeater',
                            'id' => $id,
                            'name' => esc_html__('Search criteria', 'utillz-core'),
                            'templates' => [

                                /*
                                 * field
                                 *
                                 */
                                'field' => [
                                    'name' => esc_html__( 'Match field value', 'utillz-core' ),
                                    'heading' => 'name',
                                    'fields' => [
                                        'name' => [
                                            'type' => 'text',
                                            'name' => esc_html__( 'Name', 'utillz-core' ),
                                        ],
                                        'id' => [
                                            'type' => 'key',
                                            'name' => esc_html__( 'Name', 'utillz-core' ),
                                            'defined' => true
                                        ],
                                    ]
                                ],

                                /*
                                 * taxonomy
                                 *
                                 */
                                'taxonomy' => [
                                    'name' => esc_html__( 'Match taxonomy', 'utillz-core' ),
                                    'heading' => 'name',
                                    'fields' => [
                                        'name' => [
                                            'type' => 'text',
                                            'name' => esc_html__( 'Name', 'utillz-core' ),
                                        ],
                                        'id' => [
                                            'type' => 'taxonomy_types',
                                            'name' => esc_html__( 'Select taxonomy', 'utillz-core' ),
                                            'allow_empty' => false
                                        ],
                                        'icon' => [
                                            'type' => 'icon',
                                            'name' => esc_html__( 'Select icon', 'utillz-core' ),
                                        ],
                                    ]
                                ],

                            ]
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * checkbox
                 *
                 */
                'checkbox' => [
                    'name' => esc_html__( 'Checkbox', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'key',
                            'name' => esc_html__( 'Field key', 'utillz-core' ),
                            'description' => esc_html__( 'The filder id should match the field id you created in Listing Type > Listing > Fields', 'utillz-core' ),
                            'col' => 6
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * taxonomy
                 *
                 */
                'taxonomy' => [
                    'name' => esc_html__( 'Taxonomy', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'taxonomy_types',
                            'name' => esc_html__('Taxonomy', 'utillz-core'),
                            'col' => 6,
                            'allow_empty' => false
                        ],
                        'display' => [
                            'type' => 'select',
                            'name' => esc_html__('Field type', 'utillz-core'),
                            'value' => 'select',
                            'options' => [
                                'select' => esc_html__('Select', 'utillz-core'),
                                // 'select2' => esc_html__('Select2', 'utillz-core'),
                                'checklist' => esc_html__('Checkboxes', 'utillz-core'),
                                'radio' => esc_html__('Radio buttons', 'utillz-core'),
                                // 'buttons' => esc_html__('Buttons', 'utillz-core'),
                            ],
                            'allow_empty' => false
                        ],
                        'limit_height' => [
                            'type' => 'checkbox',
                            'name' => esc_html__( 'Limit the height of the list', 'utillz-core' ),
                            'description' => esc_html__( 'Check this option if you don\'t want to display the entire checkbox list by default', 'utillz-core' ),
                            'dependency' => [
                                'id' => 'display',
                                'compare' => '=',
                                'value' => 'checklist',
                            ],
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * number
                 *
                 */
                'number' => [
                    'name' => esc_html__( 'Number', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'key',
                            'name' => esc_html__( 'Field key', 'utillz-core' ),
                            'col' => 6
                        ],
                        'input_type' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Field type', 'utillz-core' ),
                            'options' => [
                                'number' => esc_html__('Number', 'utillz-core'),
                                'range' => esc_html__('Slider', 'utillz-core'),
                                'stepper' => esc_html__('Stepper', 'utillz-core'),
                            ],
                            'allow_empty' => false,
                            'col' => 6
                        ],
                        'min' => [
                            'type' => 'number',
                            'name' => esc_html__( 'Minimum', 'utillz-core' ),
                            'col' => 6
                        ],
                        'max' => [
                            'type' => 'number',
                            'name' => esc_html__( 'Maximun', 'utillz-core' ),
                            'col' => 6
                        ],
                        'step' => [
                            'type' => 'number',
                            'name' => esc_html__( 'Step size', 'utillz-core' ),
                            'col' => 6
                        ],
                        'comparison' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Comparison', 'utillz-core' ),
                            'value' => 'equal',
                            'options' => [
                                'equal' => esc_html__('Equal', 'utillz-core'),
                                'less' => esc_html__('Less', 'utillz-core'),
                                'less_or_equal' => esc_html__('Less or equal', 'utillz-core'),
                                'greater' => esc_html__('Greater', 'utillz-core'),
                                'greater_or_equal' => esc_html__('Greater or equal', 'utillz-core'),
                            ],
                            'allow_empty' => false,
                            'col' => 6
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * geolocation
                 *
                 */
                'geo' => [
                    'name' => esc_html__( 'Geolocation', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'hidden',
                            'value' => 'geo',
                        ],
                        'placeholder' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Placeholder', 'utillz-core' ),
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                    ]
                ],

                /*
                 * heading
                 *
                 */
                'heading' => [
                    'name' => esc_html__( 'Heading', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'id' => [
                            'type' => 'auto-key',
                        ],
                        'description' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Description', 'utillz-core' ),
                            'col' => 6
                        ],
                    ]
                ],

                /*
                 * separator
                 *
                 */
                'separator' => [
                    'name' => esc_html__( 'Separator', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [

                    ]
                ],

                /*
                 * tab start
                 *
                 */
                'tab' => [
                    'name' => esc_html__( 'Tab — start', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [
                        'id' => [
                            'type' => 'auto-key',
                        ],
                        'name' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Name', 'utillz-core' ),
                            'value' => esc_html__( 'Tab name', 'utillz-core' ),
                            'col' => 6
                        ],
                        'label' => [
                            'type' => 'text',
                            'name' => esc_html__( 'Tab label', 'utillz-core' ),
                            'value' => esc_html__( 'Tab label', 'utillz-core' ),
                            'col' => 6
                        ],
                        'col' => [
                            'type' => 'select',
                            'name' => esc_html__( 'Column size', 'utillz-core' ),
                            'value' => 12,
                            'options' => Field_Column_Sizes::get(),
                            'allow_empty' => false,
                        ],
                        'icon' => [
                            'type' => 'icon',
                            'name' => esc_html__( 'Icon', 'utillz-core' ),
                        ],
                    ]
                ],

                /*
                 * tab end
                 *
                 */
                'tab_break' => [
                    'name' => esc_html__( 'Tab — end', 'utillz-core' ),
                    'heading' => 'name',
                    'fields' => [

                    ]
                ],

            ],
        ];
    }
}
